# 项目部署上线教程


你好，我是程序员鱼皮。

在前面的文章中，我们学习了如何开发各种项目。但是如果项目只能在本地运行，那就太可惜了。这篇文章，我会教你如何把项目部署到互联网上，让全世界的人都能访问。

需要先说明的是，如果你用的是 Bolt.new、Lovable、美团 NoCode、百度秒哒等 AI 零代码平台，它们一般自带了部署功能，点击发布按钮就能上线，非常方便。但是如果你想更灵活地部署，比如使用自己的域名、选择不同的服务器、或者部署更复杂的全栈项目，那就需要学习更多的部署方式。

下面我会介绍多种部署方式，从最新的 AI 自动部署、到最流行的 Vercel 一键部署、再到专业的服务器部署。你可以根据自己的项目类型和需求，选择合适的部署方式。



## 一、部署方式概览

在开始之前，先了解一下有哪些部署方式。

对于前端项目（静态网页、单页应用等），最简单的方式是使用托管平台，比如 Vercel、GitHub Pages、EdgeOne Pages 等。这些平台提供免费的托管服务，只需要上传代码，就能自动部署并生成访问链接。

对于全栈项目（包含前端和后端），可以选择容器化部署（Docker）、云服务器部署（阿里云、腾讯云等）、或者 Serverless 部署。这些方式相对复杂一些，但功能更强大。

下面我会详细介绍每种部署方式。



## 二、让 AI 自动部署（最新最酷）

先来分享一个最新的技巧，让 AI 帮你部署网站。

以前，我们开发一个网站，需要先提出需求、再设计方案、再写代码开发、最后部署上线。我们都知道 AI 现在写代码越来越溜了，慢慢地替代了我们程序员写代码的部分工作；但其实，AI 的能力不止于此，利用 MCP，它甚至可以直接帮我们把网站部署上线！

好好好，合着我只要提个一句话需求，写代码和部署都不用我来干了，让我退化是吧？

![](https://pic.yupi.icu/1/1752213314439-7925d7ba-0d1d-46f1-9f70-b1d391ac854d.png)

下面就来带大家实操一下，让 AI 帮我生成并部署个人博客网站。



### 准备工具

我们需要用到的工具包括：

- Cursor：AI 编程工具，负责调用 AI 生成代码
- EdgeOne Pages MCP：能够将网站快速部署到 CDN 并生成公开访问链接的服务

什么是 EdgeOne Pages MCP 呢？拆解一下这几个单词。

EdgeOne 是腾讯云提供的 CDN 加速服务，可以把用户的网站资源缓存到离用户最近的边缘节点，提升网站性能。

![](https://pic.yupi.icu/1/1752216739540-3dbb9132-3ae0-4a5d-9949-2a4299663c39.png)

EdgeOne Pages 是基于这个 CDN 的网站部署服务，可以让你轻松地将网站部署到 CDN 上，并且得到公开访问地址，完全不需要自己搭建服务器。

![](https://pic.yupi.icu/1/1752216784265-0a71fe3a-7944-40b2-b5ce-87215df060fe.png)

MCP 则是目前很火的模型上下文协议，让 AI 模型能够轻松地使用各种工具来增强能力，完成更复杂的任务。

![](https://pic.yupi.icu/1/1752216828838-510154d5-6a89-4089-84b9-fadeccb9d724.png)

EdgeOne Pages MCP 的作用就显而易见了 —— 给 AI 提供网站部署工具，这也是一个比较热门的 MCP。

![](https://pic.yupi.icu/1/1752217054075-0f149a76-9e42-482e-ae26-e23762c7ad1e.png)



### 快速实战

1）开通 Pages 服务

首先到 [EdgeOne 控制台](https://console.cloud.tencent.com/edgeone/pages) 开通 Pages 服务：

![](https://pic.yupi.icu/1/1752209404627-3a3193d9-4c94-4f80-ad02-435ff22f16ed.png)

开通服务后，默认进入了项目管理页面，我们先不急着创建项目：

![](https://pic.yupi.icu/1/1752209421726-11d8eff7-7bdd-4a85-accf-c70f74ead15a.png)

由于等下要通过 MCP 完成网站部署，所以要先获取 API Token，作为调用服务的凭证：

![](https://pic.yupi.icu/1/1752209504079-6741bbd0-438e-48a4-86be-6eddfc3efa83.png)



2）配置 MCP

新建一个项目文件夹 `yupi-blog`，在 Cursor 中打开，然后进入设置，添加 MCP 服务：

![](https://pic.yupi.icu/1/1752209949437-369134bc-303b-46fc-bca1-e1a57a335f82.png)

将这段配置复制粘贴到 MCP 配置文件中：

```json
{
  "mcpServers": {
    "edgeone-pages-mcp-server": {
      "command": "npx",
      "args": ["edgeone-pages-mcp"],
      "env": {
        "EDGEONE_PAGES_API_TOKEN": "你的API Token",
        "EDGEONE_PAGES_PROJECT_NAME": ""
      }
    }
  }
}
```

注意要把 API Token 改成你自己的，并且把注释删除掉，否则会报错：

![](https://pic.yupi.icu/1/1752210048110-15bf78cc-da14-4f7f-b9d5-3ec510332bf7.png)

正常情况下，你会看到 MCP 服务成功加载，绿了绿了！

![](https://pic.yupi.icu/1/1752211512400-a59c2010-8701-4b75-80d9-014ad03e8b4a.png)

这个服务提供了 2 个工具：

- deploy_html：部署 HTML 内容到 EdgeOne Pages，返回公开访问 URL
- deploy_folder_or_zip：部署文件夹或 ZIP 文件到 EdgeOne Pages，返回公开访问 URL

注意，这个 MCP 服务需要 NPX 工具才能在本地成功启动。NPX 可以直接运行 NPM 包中的命令而无需全局安装，常用于执行脚手架工具和一次性命令。

如果你没有 NPX 命令、或者 Node.js 版本过低（最好不要低于 20），都会导致工具无法加载。

![](https://pic.yupi.icu/1/1752211437222-1400be90-e460-4948-b7f3-45a6a78ffe7d.png)

这时，你只需要到 [官网安装 Node.js](https://nodejs.org/zh-cn)，会自动帮你安装 NPM 和 NPX 工具：

![](https://pic.yupi.icu/1/1752209643527-73a7c2cc-046c-4faa-8531-2a22da95d4bd.png)

如果没有自动安装 NPX 工具，那就用 NPM 包管理工具安装 NPX：

```bash
npm i -g npx
```



3）生成并部署网站

准备好 MCP 服务后，下面来生成网站。输入下列提示词，让 AI 帮我生成个人博客网站：

```
帮我根据程序员鱼皮的 GitHub 生成个人博客网站，极客风格，简洁大气；生成完成后部署网站
@https://github.com/liyupi
```

查看 AI 的思考过程，它已经想到要使用 EdgeOne Pages 去部署网站了：

![](https://pic.yupi.icu/1/1752211869664-b74dc4d9-57b1-4bb7-9f02-703112b613eb.png)

很快网站就生成并部署完成，可以看到 AI 调用了 MCP 部署 HTML 的工具，得到了访问地址：

![](https://pic.yupi.icu/1/1752212029384-16cfba8f-babb-49c0-9d41-3b76ee78eecf.png)

直接打开网址就看到效果了，不要太方便！

![](https://pic.yupi.icu/1/1752212096367-0a0fac32-118e-485a-9277-8dd507ff66d3.png)

不过目前生成的网站比较简单，就一个 HTML 页面，甚至没有在本地创建代码文件。



4）部署网站目录

再来尝试一个更复杂的项目吧，使用下面的提示词，让 AI 利用前端框架开发多页面网站：

```
帮我根据程序员鱼皮的 GitHub 生成个人博客网站，极客风格，简洁大气；
需要包含多个页面，要求使用 Vue 框架模块化开发；
生成完成后部署网站
@https://github.com/liyupi/
```

![](https://pic.yupi.icu/1/1752212265608-6aa96245-199f-487f-9c57-bc2f0550cdf6.png)

这次要等待的时间会比较久，鱼皮建议大家趁这个时间接杯水，起来活动活动。最近久坐不动，我感觉自己的肩膀已经硬如磐石了。

![](https://pic.yupi.icu/1/1752217850836-e83f0d59-a657-4048-94cd-a515e960a4d7.png)

我们会发现，虽然生成了一大堆代码，但是并没有自动部署，只是给出了部署建议：

![](https://pic.yupi.icu/1/1752213747665-192b57be-90a5-44e4-92b1-5cd468394707.png)

看一下 AI 的思考过程，原来是使用部署工具失败了：

![](https://pic.yupi.icu/1/1752214113764-2afad6bc-5777-4e9e-b2d2-745476caadc2.png)

经过我的测试发现，如果想部署网站目录或压缩包，最好先在 Pages 网页版创建一个项目，然后让 MCP 把网站文件传到这个项目内。

那就先利用官方提供的例子，随便部署一个网站：

![](https://pic.yupi.icu/1/1752215857055-9a84b9d5-4787-4181-b054-8883884c34b2.png)

修改项目的名称为 `yupi-blog`，直接点击 "开始部署" 就好：

![](https://pic.yupi.icu/1/1752215971422-9e57abea-077a-4847-88b3-bd1cd1de4217.png)

等待部署中，30 秒左右就好了：

![](https://pic.yupi.icu/1/1752216002653-9d7c5127-642a-4b3c-b542-c9e6cfcd0dde.png)

项目部署成功后，我们修改 Cursor MCP 的配置，填入刚刚创建的项目名称：

![](https://pic.yupi.icu/1/1752216064120-e1e8e58e-0eaa-4b9c-814b-605c664c35a3.png)

然后再跟 AI 对话，让它帮我部署网站目录：

![](https://pic.yupi.icu/1/1752213933060-071efc16-a9ac-4333-8fd9-53beeeeedd90.png)

可以看到这次 AI 成功执行了部署工具，并且得到了访问地址：

![](https://pic.yupi.icu/1/1752216306792-fb4c2e9c-d600-4b7c-b3c4-d5ae02614974.png)

看下网站效果，还不错吧，很有科技感！

![](https://pic.yupi.icu/1/1752216337356-667e0577-b0a5-4f44-b147-5bb3ab14824e.png)

不过要注意，生成的网站默认使用临时域名，有效期比较短：

![](https://pic.yupi.icu/1/1752216364625-c93f7b26-133a-4aac-a849-77ee6840e6f1.png)

如果你有域名的话，建议配置一下自定义域名，就可以无限期访问啦~

![](https://pic.yupi.icu/1/1752216408600-03b16e94-4668-4295-b7bb-2a07bc5592c7.png)

怎么样，是不是很简单？等能够轻松在手机上使用 MCP 的时候，试想一下，你走在路上跟朋友聊天，朋友向你推荐了一位博主 —— 程序员鱼皮，你只需要跟 AI 说一句话，2 分钟后，就能给朋友访问介绍这个博主的网站，跟变魔术似的。

![](https://pic.yupi.icu/1/1752218294278-9d31872f-e883-4736-a3f6-584ee31e9ad7.png)

值得一提的是，EdgeOne Pages 目前应该是免费的，真香了。

![](https://pic.yupi.icu/1/1752216569752-fbd0f243-7d43-44de-af69-d3d6eb954f8a.png)



## 三、Vercel 一键部署（推荐）

[Vercel](https://vercel.com) 是目前最流行的前端部署平台，特别适合 React、Next.js、Vue、静态网站等前端项目。

Vercel 的优点是个人项目完全免费，部署速度极快（一般 1 ~ 2 分钟），自动配置 HTTPS 和 CDN 加速；还和 GitHub 深度集成，能够在你推送代码到 GitHub 仓库后自动部署。



### 使用步骤

1）首先访问 [Vercel 官网](https://vercel.com) 注册账号，建议使用 GitHub 账号注册登录。

2）创建项目，可以直接绑定 GitHub 并选择已经托管的项目，点击 "Deploy" 部署按钮：

![](https://pic.yupi.icu/1/image-20260109111323983.png)

3）等待 1 ~ 2 分钟，项目就上线了！

部署成功后 Vercel 会自动给你一个域名，比如 `your-project.vercel.app`，你也可以绑定自己的域名。而且每次你往 GitHub 推送代码，Vercel 都会自动重新部署，完全不用手动操作。



### 命令行部署

除了网页操作，Vercel 还提供了命令行工具，可以让我们通过一行命令把自己的项目部署到平台。先用 NPM 安装 Vercel CLI 工具：

```bash
npm i -g vercel@latest
```

然后，直接在想部署的项目文件夹下输入 `vercel` 命令，就能部署当前项目了：

![](https://pic.yupi.icu/1/1752218682107-8c8457e4-3fbe-40d8-afb8-f6cb0691beee.png)

让 AI 完成自动部署的方法也很简单，你只需要在提示词中告诉 AI “你可以使用 vercel 命令行工具完成网站部署”，聪明如它，一定能帮你完成任务。

💡 具体过程可以看鱼皮的视频教程：https://www.bilibili.com/video/BV1TV4y1j76t

除了 Vercel，还有 [Netlify](https://www.netlify.com/) 这个类似的平台。Netlify 和 Vercel 功能差不多，但功能更全面一些，支持更多的框架和静态站点生成器，有表单处理、无服务器函数等功能，免费额度更大、还支持 A/B 测试和分析。使用方式和 Vercel 类似：注册账号 => 连接 GitHub => 选择项目 => 点击部署。如果你的项目不是 Next.js（Next.js 用 Vercel 最好），可以考虑用 Netlify。



## 四、GitHub Pages 部署

[GitHub Pages](https://pages.github.com/) 是 GitHub 提供的免费静态网站托管服务。优点是完全免费、无限流量、和 GitHub 无缝集成。

使用方法巨简单，在 GitHub 创建仓库并上传网站文件后，直接在仓库设置中启用 GitHub Pages：

![](https://pic.yupi.icu/1/image-20260109111917547.png)

然后就能通过 `username.github.io/repo-name` 访问了。适合个人主页、项目文档、简单的静态网站。

GitHub Pages 的限制是只能部署静态网站，不能运行后端代码。但对于纯前端项目来说，完全够用了。而且完全免费，不用担心流量限制。



## 五、云服务器部署

如果你想要更多的控制权，可以租一台云服务器，自己部署项目。国内主流的云服务商有阿里云、腾讯云、华为云等。

云服务器部署的基本流程：

1）购买云服务器（推荐 2 核 4G 配置起步，第一次购买有新用户优惠）

2）安装运行环境，比如 Node.js、Nginx、MySQL 数据库等

3）上传代码到服务器

4）配置 Nginx 反向代理

5）配置域名和 SSL 证书

这个过程对于纯新手来说会有点儿复杂，但可以使用宝塔面板或 1Panel 这样的可视化管理工具，大大简化操作。这些面板提供了图形化界面，不需要记复杂的命令，点点鼠标就能完成配置。

![](https://pic.yupi.icu/1/1736821032080-4be9c9e5-6dfe-434b-8db8-7eb8d7068a16.png)

云服务器部署的优点是你有完全的控制权，可以随时调整配置，而且更稳定。缺点是需要一定的编程或运维知识，而且服务器需要付费（一般每月几十到几百元不等）。

💡 具体过程可以看鱼皮的视频教程：
- [云端编辑器 + Vercel + 对象存储 + 内网穿透 4 种方式部署](https://www.bilibili.com/video/BV1UZ4y197i1)
- [Nginx + 宝塔 2 种方式部署个人博客](https://www.bilibili.com/video/BV1rU4y1J785)
- [WordPress 搭建个人博客](https://www.bilibili.com/video/BV14q4y1R7XM)
- [4 种主流前后端项目部署](https://www.codefather.cn/course/1790943469757837313/section/1791075571845345281?contentType=video&tabKey=videoList)

鱼皮在编程导航带大家做过 20 多套项目了，几乎每种部署方式都给大家讲解过：

- [AI 零代码应用生成平台项目](https://www.codefather.cn/course/1948291549923344386)：1Panel 面板 + Nginx 前端 + Java 后端（jar 包）
- [代码生成器共享平台项目](https://www.codefather.cn/course/1790980795074654209)：宝塔面板 + Nginx 前端 + Java 项目管理器（jar 包）后端部署

基本上学会这几种部署方式，能够应对绝大多数部署需求了。



## 六、Docker 容器化部署

对于包含前端和后端的全栈项目，Docker 是一个很好的部署方式。Docker 可以把你的应用和运行环境打包成一个容器，在任何支持 Docker 的服务器上都能运行。

Docker 的优点是环境一致性好，不会出现 “在我电脑上能跑，在服务器上跑不了” 的问题。而且可以很方便地管理多个应用，每个应用独立运行，互不影响。

使用 Docker 部署的基本流程：

1. 编写 Dockerfile，定义应用的运行环境
2. 构建 Docker 镜像
3. 运行 Docker 容器
4. 配置 Nginx 反向代理（如果需要）

这个过程相对复杂一些，但可以让 AI 帮你完成。你只需要告诉 AI：“帮我写一个 Dockerfile，用来部署这个 Node.js 项目。” AI 会生成完整的 Dockerfile 和部署脚本。

如果你想学习企业级的部署方式，建议深入学习 Docker。

💡 具体过程可以看鱼皮的项目教程：
- [AI 答题应用平台项目](https://www.codefather.cn/course/1790274408835506178)：Vercel 前端 + Docker 后端 + 云托管 Serverless 平台部署
- [AI 超级智能体项目](https://www.codefather.cn/course/1915010091721236482)：Docker 前端 + Docker 后端 + 云托管 Serverless 平台部署
- [OJ 在线判题项目](https://www.codefather.cn/course/1790980707917017089)：Docker Compose 后端微服务部署



## 七、CDN 加速优化

部署完成后，如果你想让网站访问速度更快，还可以使用 CDN 加速。

CDN（内容分发网络）就是把你的网站内容缓存到全球各地的服务器上，用户访问时会自动选择离他最近的服务器，大大提高加载速度。

![](https://pic.yupi.icu/1/1763643073516-5248d56c-bf7d-4537-b8f8-681a104626d9.png)

[Cloudflare](https://www.cloudflare.com/zh-cn/) 提供免费的 CDN 服务，优势是：

- 完全免费（个人网站）
- 全球 CDN 加速，覆盖 200+ 个城市
- 自动 HTTPS 证书
- DDoS 防护和 Web 防火墙
- 免费的 DNS 服务

使用方法很简单，注册 Cloudflare 账号，添加你的域名，然后把域名的 DNS 服务器改成 Cloudflare 提供的地址就行。Cloudflare 会自动帮你加速和保护网站。

也可以直接使用 Cloudflare 提供的 Pages 页面部署能力，直接上传自己的代码，交给它一键部署并白票免费的域名，更方便~

![](https://pic.yupi.icu/1/1763643412558-4d499b46-5e16-4f83-9df7-06a85175df35.png)

如果你的网站部署在 Vercel 或 Netlify 上，它们本身就有 CDN 加速，不需要额外配置 Cloudflare。但如果你是自己租服务器部署，强烈建议用 Cloudflare 加速。



## 八、域名和 SSL 证书

部署完成后，你可能想给网站配置一个好记的域名，而不是一直用难以记忆的 IP 地址让用户访问。



### 购买域名

域名就是网站的地址，比如 [codefather.cn](https://codefather.cn/)、[dogyupi.com](http://dogyupi.com/)。对于国内用户，我推荐在 [阿里云](https://wanwang.aliyun.com/) 或 [腾讯云](https://dnspod.cloud.tencent.com/) 这种知名云服务商购买域名。价格一般是几十块钱一年，而且操作界面都是中文的，很方便。

需要注意的是，如果你的网站服务器在国内，域名需要备案。备案流程大概需要 1 ~ 2 周，需要提供身份证、手机号等信息。如果你的网站部署在 Vercel、Netlify 这些国外平台上，或者在国外平台购买域名，那么可以省去备案，快速上线。



### 配置 SSL 证书

现在的网站基本都要求 HTTPS，所以需要配置 SSL 证书。好消息是，大部分部署平台都会自动配置 SSL 证书，你不需要手动操作。

比如 Vercel、Netlify、GitHub Pages、EdgeOne Pages 都会自动配置 HTTPS，你只需要绑定域名就行。

如果你是自己租服务器部署，可以使用免费的 [Let's Encrypt](https://letsencrypt.org/zh-cn/) 证书，或者用 Cloudflare 的 CDN，它们都会自动配置 HTTPS。



## 写在最后

通过这篇文章，你已经学习了多种项目部署方式。从最新的 AI 自动部署，到最流行的 Vercel 一键部署，从简单的 GitHub Pages，到专业的云服务器和 Docker 容器化部署，每种方式都有自己的适用场景。

我建议对于新手，从简单的开始。如果你用的是 AI 零代码平台，直接用它自带的发布功能就好。如果你用 Cursor 等代码编辑器开发，推荐先用 Vercel 或 GitHub Pages，几分钟就能上线。等你熟练了，再学习 Docker 和云服务器部署，这些是企业级的部署方式，更专业也更灵活。

现在，选择一个适合你的部署方式，把你的项目发布到互联网上吧~




## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
